# 2590地区インターアクト研修旅行サイト 現行仕様書

## 📋 基本情報

**サイトタイトル：** 2025年度 国際ロータリー第２５９０地区インターアクト研修旅行  
**開催期間：** 2025年12月26日（金）～28日（日）  
**公開予定：** 2025年12月6日（説明会）  
**URL：** https://2590interact.net

## 🎯 機能要件

### 📢 1. お知らせ機能（最上位コンテンツ）
- **目的：** 事前課題、説明会情報の告知
- **管理：** 管理画面から追加・編集・削除
- **表示：** 投稿日時順、最新が上
- **内容：** タイトル + 本文（HTML対応）

### 📅 2. 行程表管理
- **表示形式：** 日付・時間・内容・場所
- **管理：** 管理画面から編集可能
- **特記：** 今後変更の可能性があるため柔軟性重視

### 👥 3. 参加者管理
#### 参加者分類
- **参加学生**
- **同行者**

#### 学生の基本情報（管理者が設定）
- 顔写真（アップロード機能）
- 名前
- 学校名
- 学年
- 班名（A～F班）

#### 学生の個別編集項目（学生本人が編集）
- **趣味**
- **研修への意気込み**
- **認証：** 管理者が設定する個別パスワード

### 📋 4. 必要情報
- **内容：** 持ち物、注意事項など
- **管理：** 管理画面から編集可能

## 🏗️ 技術仕様

### 開発環境
- **サーバー：** ConoHa VPS Ubuntu
- **Webサーバー：** Apache2.4
- **アプリケーション：** Node.js + Express
- **データベース：** SQLite
- **テンプレート：** EJS
- **SSL：** Let's Encrypt（設定済み）

### 現在の構成
```
本番環境: https://2590interact.net (Apache + Node.js ポート3000)
開発環境: ~/Developer/projects/interact-travel-site (ローカル)
```

### セキュリティ要件
- ✅ HTTPS強制リダイレクト
- ✅ セキュリティヘッダー設定済み
- ✅ robots.txt（全ページ検索避け）
- ✅ noindexメタタグ必須

## 👤 ユーザー権限

### 管理者
- **機能：** 全コンテンツの管理
- **認証：** 管理者用ログイン
- **権限：** CRUD操作、画像アップロード、パスワード管理

### 学生
- **機能：** 自身のプロフィール編集のみ
- **認証：** 管理者設定の個別パスワード
- **編集項目：** 趣味、研修への意気込み

### 一般ユーザー（参加者・保護者等）
- **機能：** 閲覧のみ
- **認証：** なし

## 🎨 UI/UX要件

### デザイン方針
- **清潔感のあるデザイン**
- **ロータリーブルー（#2590ff）**をメインカラー
- **レスポンシブデザイン**（スマートフォン対応重要）

### ページ構成
```
📄 メインページ (/)
├── 🔔 お知らせ（最上位）
├── 📅 行程表
├── 👥 参加者一覧
└── 📋 必要情報

📄 管理画面 (/admin)
├── 📊 ダッシュボード
├── 🔔 お知らせ管理
├── 📅 行程表管理
├── 👥 参加者管理
└── 📋 必要情報管理

📄 学生ページ (/student/:id)
└── ✏️ プロフィール編集
```

## 📊 データ構造

### データベーステーブル
1. **news** - お知らせ
2. **schedules** - 行程表
3. **participants** - 参加者基本情報
4. **student_profiles** - 学生プロフィール
5. **information** - 必要情報
6. **admins** - 管理者

## ⚡ パフォーマンス要件

### 現状の課題
- **時間ごとの読み込み直し** → リアルタイム更新に改善希望

### 改善案
- **WebSocket実装**でリアルタイム更新
- **キャッシュ機能**で高速表示
- **画像最適化**（WebP対応）

## 🚀 開発スケジュール

### 緊急スケジュール
- **11月1日まで：** 基盤機能完成
- **11月15日まで：** 管理画面完成
- **11月30日まで：** 学生機能完成
- **12月5日まで：** 最終調整
- **12月6日：** 説明会で公開

### 優先順位
1. **Phase 1:** お知らせ + 行程表 + 参加者表示
2. **Phase 2:** 管理画面（CRUD操作）
3. **Phase 3:** 学生ログイン + プロフィール編集
4. **Phase 4:** リアルタイム更新 + 最適化

## 🧪 開発フロー

### 現在の状況
- ✅ 本番サーバー環境構築完了
- ✅ SSL証明書設定完了
- ✅ ローカル開発環境準備完了
- 🔄 **次：Claude Codeで実装開始**

### デプロイ戦略
```
ローカル開発 → テスト → Git管理 → 本番デプロイ
```

## 📋 実装チェックリスト

### 基本機能
- [ ] お知らせ表示・管理
- [ ] 行程表表示・管理  
- [ ] 参加者一覧表示・管理
- [ ] 必要情報表示・管理
- [ ] 管理者認証
- [ ] 学生認証・プロフィール編集

### 追加機能
- [ ] 画像アップロード・リサイズ
- [ ] レスポンシブデザイン
- [ ] WebSocketリアルタイム更新
- [ ] セキュリティ強化

### デプロイ準備
- [ ] 本番環境設定
- [ ] データ移行
- [ ] 最終テスト

## 🤖 Claude Code向け実装ポイント

### 重要な仕様
1. **学生の班名：** A～F班（6班制）
2. **画像アップロード：** 管理者のみ、参加者の顔写真
3. **個別パスワード：** 管理者が学生ごとに設定
4. **検索回避：** robots.txt + noindexで完全非公開
5. **リアルタイム更新：** 管理者の変更を即座に反映

### 初期データ要件
- 管理者アカウント：admin / dev2590
- サンプルお知らせ3件
- サンプル参加者10名程度
- 3日間の行程表サンプル