const express = require('express');
const { getDatabase } = require('../scripts/database');
const router = express.Router();

// メインページ
router.get('/', async (req, res) => {
    try {
        const db = getDatabase();
        
        // データを並列取得
        const [news, schedules, participants, information] = await Promise.all([
            new Promise((resolve, reject) => {
                db.all('SELECT * FROM news ORDER BY created_at DESC', (err, rows) => {
                    if (err) reject(err);
                    else resolve(rows);
                });
            }),
            new Promise((resolve, reject) => {
                db.all(`SELECT * FROM schedules ORDER BY date ASC, time ASC`, (err, rows) => {
                    if (err) reject(err);
                    else resolve(rows);
                });
            }),
            new Promise((resolve, reject) => {
                db.all('SELECT * FROM participants ORDER BY type, team, name', (err, rows) => {
                    if (err) reject(err);
                    else resolve(rows);
                });
            }),
            new Promise((resolve, reject) => {
                db.all('SELECT * FROM information ORDER BY created_at DESC', (err, rows) => {
                    if (err) reject(err);
                    else resolve(rows);
                });
            })
        ]);
        
        db.close();
        
        // タイプ別とチーム別にグループ化
        const participantsByType = {
            students: participants.filter(p => p.type === 'student'),
            companions: participants.filter(p => p.type === 'companion'),
            chaperones: participants.filter(p => p.type === 'chaperone')
        };
        
        // 学生は班ごとにさらにグループ化
        const studentsByTeam = participantsByType.students.reduce((acc, student) => {
            if (!acc[student.team]) {
                acc[student.team] = [];
            }
            acc[student.team].push(student);
            return acc;
        }, {});
        
        res.render('index', {
            title: '2025年度 国際ロータリー第２５９０地区インターアクト研修旅行',
            news,
            schedules,
            participantsByType,
            studentsByTeam,
            students: participantsByType.students,
            information,
            query: req.query
        });
    } catch (error) {
        console.error('メインページ取得エラー:', error);
        res.status(500).render('error', {
            title: 'エラー',
            message: 'データの取得に失敗しました。',
            error: error
        });
    }
});

module.exports = router;