// ========================================
// ナビゲーション機能
// ========================================

document.addEventListener('DOMContentLoaded', function() {
    initNavigation();
});

function initNavigation() {
    // スムーズスクロール
    setupSmoothScroll();

    // スクロール時のアクティブ表示
    setupScrollSpy();

    // スクロール時のナビゲーションスタイル変更
    setupStickyNavScroll();
}

// スムーズスクロール機能
function setupSmoothScroll() {
    const navLinks = document.querySelectorAll('.nav-link');

    navLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();

            const targetId = this.getAttribute('href');
            const targetSection = document.querySelector(targetId);

            if (targetSection) {
                const navHeight = document.querySelector('.sticky-nav').offsetHeight;
                const targetPosition = targetSection.offsetTop - navHeight;

                window.scrollTo({
                    top: targetPosition,
                    behavior: 'smooth'
                });

                // アクティブ状態を即座に更新
                updateActiveLink(targetId);
            }
        });
    });
}

// スクロールスパイ（現在表示中のセクションをハイライト）
function setupScrollSpy() {
    const sections = document.querySelectorAll('.content-section');
    const navLinks = document.querySelectorAll('.nav-link');
    const navHeight = document.querySelector('.sticky-nav').offsetHeight;

    window.addEventListener('scroll', () => {
        let currentSection = '';

        sections.forEach(section => {
            const sectionTop = section.offsetTop - navHeight - 100;
            const sectionHeight = section.offsetHeight;
            const scrollPosition = window.pageYOffset;

            if (scrollPosition >= sectionTop && scrollPosition < sectionTop + sectionHeight) {
                currentSection = '#' + section.getAttribute('id');
            }
        });

        if (currentSection) {
            updateActiveLink(currentSection);
        }
    });
}

// アクティブリンク更新
function updateActiveLink(targetId) {
    const navLinks = document.querySelectorAll('.nav-link');

    navLinks.forEach(link => {
        link.classList.remove('active');
        if (link.getAttribute('href') === targetId) {
            link.classList.add('active');
        }
    });
}

// スクロール時のナビゲーションスタイル変更
function setupStickyNavScroll() {
    const stickyNav = document.querySelector('.sticky-nav');
    let lastScrollTop = 0;

    window.addEventListener('scroll', () => {
        const scrollTop = window.pageYOffset || document.documentElement.scrollTop;

        if (scrollTop > 100) {
            stickyNav.classList.add('scrolled');
        } else {
            stickyNav.classList.remove('scrolled');
        }

        lastScrollTop = scrollTop;
    });
}

// ページトップボタン（オプション）
function createScrollToTopButton() {
    const button = document.createElement('button');
    button.id = 'scrollToTop';
    button.className = 'scroll-to-top';
    button.innerHTML = '<i class="bi bi-arrow-up-circle-fill"></i>';
    button.style.display = 'none';

    document.body.appendChild(button);

    window.addEventListener('scroll', () => {
        if (window.pageYOffset > 300) {
            button.style.display = 'block';
        } else {
            button.style.display = 'none';
        }
    });

    button.addEventListener('click', () => {
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    });
}

// オプション：ページトップボタンを有効化する場合
// createScrollToTopButton();