# 本番環境デプロイ完全手順書

## 🎯 デプロイ概要
ローカル開発環境（~/Developer/projects/interact-travel-site）から本番サーバー（2590interact.net）へ完全上書きデプロイ

## ⚠️ 重要な注意事項
- **本番環境のバックアップを必ず取得**
- **作業中はサイトがダウンします**（5-10分程度）
- **データベースの移行方法を選択**（既存データ保持 or 新規データ）

## 📋 事前準備

### 1. ローカル環境の最終確認
```bash
# ローカル開発環境で動作確認
cd ~/Developer/projects/interact-travel-site
npm run dev

# ブラウザで最終チェック
# http://localhost:3000
# - 全機能が正常動作
# - エラーがない
# - デザインが完成している
```

### 2. 本番用設定ファイル準備
```bash
# 本番用環境変数ファイル作成
cat > .env.production << 'EOF'
NODE_ENV=production
PORT=3000
SESSION_SECRET=your-secure-random-string-here
ADMIN_PASSWORD=admin2590
EOF
```

### 3. 不要なファイルを除外
```bash
# .gitignore が正しく設定されているか確認
cat .gitignore

# 以下が含まれていることを確認
# node_modules/
# *.log
# .env
# .DS_Store
# database.sqlite (データベースは別途移行)
```

## 🚀 デプロイ手順

### Step 1: 本番環境バックアップ

```bash
# サーバーにSSH接続
ssh totenagashi@163.44.110.176

# 本番環境の完全バックアップ
sudo mkdir -p /var/www/backups
sudo cp -r /var/www/2590interact.net/interact /var/www/backups/interact_backup_$(date +%Y%m%d_%H%M%S)

# バックアップ確認
ls -la /var/www/backups/

# データベースバックアップ
sudo cp /var/www/2590interact.net/interact/database.sqlite /var/www/backups/database_$(date +%Y%m%d_%H%M%S).sqlite

# 一旦ログアウト
exit
```

### Step 2: ローカルファイルを圧縮

```bash
# ローカルMacで実行
cd ~/Developer/projects/interact-travel-site

# 不要なファイルを除外して圧縮
tar -czf interact-site.tar.gz \
    --exclude='node_modules' \
    --exclude='.git' \
    --exclude='database.sqlite' \
    --exclude='*.log' \
    --exclude='.DS_Store' \
    --exclude='.env' \
    .

# 圧縮ファイル確認
ls -lh interact-site.tar.gz
```

### Step 3: サーバーへファイル転送

```bash
# ローカルからサーバーへファイル転送
scp interact-site.tar.gz totenagashi@163.44.110.176:/tmp/

# 転送完了確認
ssh totenagashi@163.44.110.176 "ls -lh /tmp/interact-site.tar.gz"
```

### Step 4: 本番環境停止・配置

```bash
# サーバーにSSH接続
ssh totenagashi@163.44.110.176

# 既存のNode.jsプロセス停止
sudo pkill -f "node.*server.js"
sudo pkill -f "node.*app.js"

# Apacheも一時停止（オプション）
sudo systemctl stop apache2

# 既存ファイルを退避（念のため2重バックアップ）
sudo mv /var/www/2590interact.net/interact /var/www/2590interact.net/interact_old

# 新しいディレクトリ作成
sudo mkdir -p /var/www/2590interact.net/interact

# ファイル展開
cd /var/www/2590interact.net/interact
sudo tar -xzf /tmp/interact-site.tar.gz

# 権限設定
sudo chown -R www-data:www-data /var/www/2590interact.net/interact
```

### Step 5: 本番環境セットアップ

```bash
# 依存関係インストール
cd /var/www/2590interact.net/interact
sudo npm install --production

# 本番用環境変数設定
sudo nano .env
# 以下を入力：
# NODE_ENV=production
# PORT=3000
# SESSION_SECRET=your-secure-random-string-here

# アップロードディレクトリ作成
sudo mkdir -p public/uploads
sudo chown -R www-data:www-data public/uploads
sudo chmod 755 public/uploads
```

### Step 6: データベース選択

#### オプションA: 新規データベース（推奨：初回デプロイ）
```bash
# 新規データベース作成
sudo npm run init-db

# 管理者アカウント確認
sqlite3 database.sqlite "SELECT * FROM admins;"
```

#### オプションB: 既存データベース移行
```bash
# ローカルからデータベースを転送（Macで実行）
scp ~/Developer/projects/interact-travel-site/database.sqlite \
    totenagashi@163.44.110.176:/tmp/

# サーバー側で配置（サーバーで実行）
sudo mv /tmp/database.sqlite /var/www/2590interact.net/interact/
sudo chown www-data:www-data /var/www/2590interact.net/interact/database.sqlite
```

#### オプションC: 旧環境からデータ移行
```bash
# 旧環境のデータベースをコピー
sudo cp /var/www/2590interact.net/interact_old/database.sqlite \
       /var/www/2590interact.net/interact/database.sqlite
       
sudo chown www-data:www-data /var/www/2590interact.net/interact/database.sqlite
```

### Step 7: PM2でプロセス管理設定

```bash
# PM2インストール（未インストールの場合）
sudo npm install -g pm2

# 既存のPM2プロセス停止・削除
pm2 delete all

# 新しいアプリケーション起動
cd /var/www/2590interact.net/interact
pm2 start app.js --name interact-site

# PM2自動起動設定
pm2 startup
pm2 save

# プロセス確認
pm2 status
pm2 logs interact-site --lines 20
```

### Step 8: Apache再起動

```bash
# Apache設定確認
sudo apache2ctl configtest

# Apache再起動
sudo systemctl start apache2
sudo systemctl status apache2
```

### Step 9: 動作確認

```bash
# サーバー上で確認
curl -I http://localhost:3000
curl -I https://2590interact.net

# ログ確認
pm2 logs interact-site --lines 50
sudo tail -f /var/log/apache2/2590interact.net_ssl_error.log
```

### Step 10: ブラウザで最終確認

```
1. https://2590interact.net にアクセス
2. すべてのページが表示されることを確認
3. 管理画面ログイン確認
4. 各機能の動作確認
```

## 🔄 ロールバック手順（問題発生時）

```bash
# SSH接続
ssh totenagashi@163.44.110.176

# PM2停止
pm2 delete interact-site

# 新環境を削除
sudo rm -rf /var/www/2590interact.net/interact

# 旧環境を復元
sudo mv /var/www/2590interact.net/interact_old /var/www/2590interact.net/interact

# PM2再起動
cd /var/www/2590interact.net/interact
pm2 start app.js --name interact-site
pm2 save

# Apache再起動
sudo systemctl restart apache2

# 確認
curl -I https://2590interact.net
```

## 📊 デプロイ後の確認項目

### 機能確認
- [ ] トップページ表示
- [ ] お知らせ表示
- [ ] 行程表表示
- [ ] 参加者一覧表示（学生・同行者・引率者）
- [ ] 学生個別ページ表示・編集
- [ ] 必要情報表示
- [ ] ナビゲーションメニュー動作

### 管理機能確認
- [ ] 管理画面ログイン
- [ ] お知らせ管理（CRUD + 一括削除）
- [ ] 行程表管理（CRUD + 一括削除）
- [ ] 参加者管理（CRUD + 一括削除）
- [ ] 必要情報管理（CRUD + 一括削除）
- [ ] 画像アップロード

### セキュリティ確認
- [ ] HTTPS強制リダイレクト動作
- [ ] robots.txt設定（noindex）
- [ ] セキュリティヘッダー設定

### パフォーマンス確認
- [ ] ページ読み込み速度
- [ ] データベースクエリ速度
- [ ] 画像表示速度

## 🛠️ トラブルシューティング

### 問題1: サイトが表示されない
```bash
# Node.js プロセス確認
pm2 status
pm2 logs interact-site

# ポート確認
sudo ss -tlnp | grep :3000

# Apache確認
sudo systemctl status apache2
```

### 問題2: 管理画面にログインできない
```bash
# データベース確認
sqlite3 /var/www/2590interact.net/interact/database.sqlite
SELECT * FROM admins;
.quit

# 管理者アカウント再作成
cd /var/www/2590interact.net/interact
sudo npm run init-db
```

### 問題3: 画像が表示されない
```bash
# アップロードディレクトリ確認
ls -la /var/www/2590interact.net/interact/public/uploads/
sudo chmod 755 /var/www/2590interact.net/interact/public/uploads
sudo chown -R www-data:www-data /var/www/2590interact.net/interact/public/uploads
```

### 問題4: データベースエラー
```bash
# データベースファイル確認
ls -la /var/www/2590interact.net/interact/database.sqlite
sudo chown www-data:www-data /var/www/2590interact.net/interact/database.sqlite
sudo chmod 664 /var/www/2590interact.net/interact/database.sqlite
```

## 📝 デプロイチェックリスト

### デプロイ前
- [ ] ローカルで最終動作確認
- [ ] 本番環境バックアップ取得
- [ ] デプロイ手順の確認
- [ ] ロールバック手順の理解

### デプロイ中
- [ ] ファイル転送完了
- [ ] 依存関係インストール完了
- [ ] データベース設定完了
- [ ] PM2起動完了

### デプロイ後
- [ ] サイト表示確認
- [ ] 全機能動作確認
- [ ] ログにエラーなし
- [ ] 旧環境の整理（数日後）

## 🎉 デプロイ完了後

```bash
# 不要な一時ファイル削除
rm /tmp/interact-site.tar.gz

# 旧環境は数日間保持（問題なければ削除）
# sudo rm -rf /var/www/2590interact.net/interact_old

# デプロイログ記録
echo "$(date): 本番環境デプロイ完了" >> /var/www/deploy.log
```

---

**所要時間:** 約10-15分
**ダウンタイム:** 約5-10分
**リスク:** バックアップ取得済みのため低リスク