# 本番環境デプロイ完全手順書（修正版）

## 🎯 デプロイ概要
ローカル開発環境（~/Developer/projects/interact-travel-site）から本番サーバー（2590interact.net）へ完全上書きデプロイ

**重要**: ローカルで作成したデータベース（database.db）をそのまま本番環境に反映します

## ⚠️ 重要な注意事項
- **本番環境のバックアップを必ず取得**
- **作業中はサイトがダウンします**（5-10分程度）
- **ローカルのデータベースをそのまま使用**（database.db）

## 📋 事前準備

### 1. ローカル環境の最終確認
```bash
# ローカル開発環境で動作確認
cd ~/Developer/projects/interact-travel-site
npm run dev

# ブラウザで最終チェック
# http://localhost:3000
# - 全機能が正常動作している
# - エラーがない
# - データベースに必要なデータが入っている
# - 学生の名前ボタンが表示される（fix014対応）
# - G班が表示される
```

### 2. データベースの最終確認
```bash
# データベースファイルの存在確認
ls -lh database.db

# データベースの内容確認
sqlite3 database.db "SELECT COUNT(*) FROM participants WHERE type='student';"
sqlite3 database.db "SELECT * FROM admins;"
```

### 3. 不要なファイルを除外確認
```bash
# .gitignore が正しく設定されているか確認
cat .gitignore

# 以下が含まれていることを確認（database.dbは含めない）
# node_modules/
# *.log
# .env
# .DS_Store
```

## 🚀 デプロイ手順

### Step 1: 本番環境バックアップ

```bash
# サーバーにSSH接続
ssh totenagashi@163.44.110.176

# 本番環境の完全バックアップ
sudo mkdir -p /var/www/backups
sudo cp -r /var/www/2590interact.net/interact /var/www/backups/interact_backup_$(date +%Y%m%d_%H%M%S)

# バックアップ確認
ls -la /var/www/backups/

# データベースバックアップ（database.dbとして）
sudo cp /var/www/2590interact.net/interact/database.db /var/www/backups/database_$(date +%Y%m%d_%H%M%S).db

# 一旦ログアウト
exit
```

### Step 2: ローカルファイルを圧縮（database.dbを含める）

```bash
# ローカルMacで実行
cd ~/Developer/projects/interact-travel-site

# データベースを含めて圧縮（database.dbも含める）
tar -czf interact-site.tar.gz \
    --exclude='node_modules' \
    --exclude='.git' \
    --exclude='*.log' \
    --exclude='.DS_Store' \
    --exclude='.env' \
    .

# 圧縮ファイル確認
ls -lh interact-site.tar.gz

# 重要: database.dbが含まれているか確認
tar -tzf interact-site.tar.gz | grep database.db
```

### Step 3: サーバーへファイル転送

```bash
# ローカルからサーバーへファイル転送
scp interact-site.tar.gz totenagashi@163.44.110.176:/tmp/

# 転送完了確認
ssh totenagashi@163.44.110.176 "ls -lh /tmp/interact-site.tar.gz"
```

### Step 4: 本番環境停止・配置

```bash
# サーバーにSSH接続
ssh totenagashi@163.44.110.176

# 既存のNode.jsプロセス停止
sudo pkill -f "node.*app.js"

# PM2を使用している場合
pm2 stop all
pm2 delete all

# 既存ファイルを退避（念のため2重バックアップ）
sudo mv /var/www/2590interact.net/interact /var/www/2590interact.net/interact_old_$(date +%Y%m%d_%H%M%S)

# 新しいディレクトリ作成
sudo mkdir -p /var/www/2590interact.net/interact

# ファイル展開
cd /var/www/2590interact.net/interact
sudo tar -xzf /tmp/interact-site.tar.gz

# 展開確認（database.dbが存在するか確認）
ls -la database.db

# 権限設定
sudo chown -R www-data:www-data /var/www/2590interact.net/interact
```

### Step 5: 本番環境セットアップ

```bash
# 依存関係インストール
cd /var/www/2590interact.net/interact
sudo npm install --production

# インストール確認
ls -la node_modules/

# 本番用環境変数設定（必要に応じて）
sudo nano .env
# 以下を入力（オプション）：
# NODE_ENV=production
# PORT=3000
# SESSION_SECRET=your-secure-random-string-here

# アップロードディレクトリ作成・権限設定
sudo mkdir -p public/uploads
sudo chown -R www-data:www-data public/uploads
sudo chmod 755 public/uploads

# データベースファイルの権限設定（重要）
sudo chown www-data:www-data database.db
sudo chmod 664 database.db
```

### Step 6: データベース確認

```bash
# ローカルから持ってきたデータベースの内容確認
sqlite3 database.db "SELECT COUNT(*) FROM participants WHERE type='student';"
sqlite3 database.db "SELECT * FROM admins;"
sqlite3 database.db "SELECT DISTINCT group FROM participants WHERE type='student';"

# G班が含まれているか確認
sqlite3 database.db "SELECT name, school, group FROM participants WHERE group='G';"
```

### Step 7: PM2でプロセス管理設定

```bash
# PM2インストール確認（未インストールの場合）
which pm2 || sudo npm install -g pm2

# 新しいアプリケーション起動
cd /var/www/2590interact.net/interact
pm2 start app.js --name interact-site

# PM2自動起動設定
pm2 startup
pm2 save

# プロセス確認
pm2 status
pm2 logs interact-site --lines 20
```

### Step 8: Apache再起動

```bash
# Apache設定確認
sudo apache2ctl configtest

# Apacheが停止している場合は起動、動作中なら再起動
sudo systemctl restart apache2

# ステータス確認
sudo systemctl status apache2
```

### Step 9: 動作確認

```bash
# サーバー上で確認
curl -I http://localhost:3000
curl -I https://2590interact.net

# ログ確認
pm2 logs interact-site --lines 50
sudo tail -f /var/log/apache2/2590interact.net_ssl_error.log
```

### Step 10: ブラウザで最終確認

```
1. https://2590interact.net にアクセス
   - メインページが表示される
   - お知らせ、行程表、参加者が表示される
   - G班が表示される

2. https://2590interact.net/#student-login にアクセス
   - 学生名ボタンが一覧表示される（fix014の機能）
   - ボタンをクリック→パスワード入力ページが表示される
   - ログインできる

3. https://2590interact.net/admin にアクセス
   - 管理画面にログインできる（admin / dev2590）
   - CRUD操作ができる
   - G班が選択肢に表示される
```

## 🔄 ロールバック手順（問題発生時）

```bash
# SSH接続
ssh totenagashi@163.44.110.176

# PM2停止
pm2 delete interact-site

# 新環境を削除
sudo rm -rf /var/www/2590interact.net/interact

# 旧環境を復元（最新のバックアップを指定）
sudo cp -r /var/www/backups/interact_backup_YYYYMMDD_HHMMSS /var/www/2590interact.net/interact

# または interact_old から復元
sudo mv /var/www/2590interact.net/interact_old_YYYYMMDD_HHMMSS /var/www/2590interact.net/interact

# PM2再起動
cd /var/www/2590interact.net/interact
pm2 start app.js --name interact-site
pm2 save

# Apache再起動
sudo systemctl restart apache2

# 確認
curl -I https://2590interact.net
pm2 logs interact-site
```

## 📊 デプロイ後の確認項目

### 基本機能確認
- [ ] トップページ表示
- [ ] お知らせ表示
- [ ] 行程表表示
- [ ] 参加者一覧表示（学生・同行者・引率者）
- [ ] 必要情報表示
- [ ] ナビゲーションメニュー動作

### fix014の新機能確認
- [ ] 学生ログインセクションに学生名ボタンが一覧表示される
- [ ] 学生名ボタンをクリック→パスワード入力ページが表示される
- [ ] パスワード入力→ログイン成功→編集ページにリダイレクト
- [ ] プロフィール編集・保存ができる

### 管理機能確認
- [ ] 管理画面ログイン（admin / dev2590）
- [ ] お知らせ管理（CRUD + 一括削除）
- [ ] 行程表管理（CRUD + 一括削除）
- [ ] 参加者管理（CRUD + 一括削除）
- [ ] G班が選択肢に表示される
- [ ] G班の学生が追加できる
- [ ] 必要情報管理（CRUD + 一括削除）
- [ ] 画像アップロード

### データ確認
- [ ] ローカルで作成した学生データが表示される
- [ ] ローカルで作成したお知らせが表示される
- [ ] ローカルで作成した行程表が表示される
- [ ] G班の学生が表示される

### セキュリティ確認
- [ ] HTTPS強制リダイレクト動作
- [ ] robots.txt設定（noindex）
- [ ] 管理画面の認証が機能している
- [ ] 学生プロフィール編集の認証が機能している

## 🛠️ トラブルシューティング

### 問題1: サイトが表示されない
```bash
# Node.js プロセス確認
pm2 status
pm2 logs interact-site

# ポート確認
sudo ss -tlnp | grep :3000

# Apache確認
sudo systemctl status apache2

# 再起動
pm2 restart interact-site
sudo systemctl restart apache2
```

### 問題2: 学生名ボタンが表示されない
```bash
# データベース確認
sqlite3 /var/www/2590interact.net/interact/database.db
SELECT COUNT(*) FROM participants WHERE type='student';
SELECT name, school, group FROM participants WHERE type='student' LIMIT 5;
.quit

# ログ確認
pm2 logs interact-site

# routes/index.jsでstudentsデータが渡されているか確認
cat /var/www/2590interact.net/interact/routes/index.js | grep "students"
```

### 問題3: 管理画面にログインできない
```bash
# データベース確認
sqlite3 /var/www/2590interact.net/interact/database.db
SELECT * FROM admins;
.quit

# 管理者アカウントが存在しない場合、再作成
cd /var/www/2590interact.net/interact
sudo node scripts/database.js
```

### 問題4: 画像が表示されない
```bash
# アップロードディレクトリ確認
ls -la /var/www/2590interact.net/interact/public/uploads/
sudo chmod 755 /var/www/2590interact.net/interact/public/uploads
sudo chown -R www-data:www-data /var/www/2590interact.net/interact/public/uploads
```

### 問題5: データベースエラー
```bash
# データベースファイル確認
ls -la /var/www/2590interact.net/interact/database.db

# 権限修正
sudo chown www-data:www-data /var/www/2590interact.net/interact/database.db
sudo chmod 664 /var/www/2590interact.net/interact/database.db

# アプリケーション再起動
pm2 restart interact-site
```

### 問題6: G班が表示されない
```bash
# データベース確認
sqlite3 /var/www/2590interact.net/interact/database.db
SELECT DISTINCT group FROM participants WHERE type='student';
SELECT name, group FROM participants WHERE group='G';
.quit

# routes/index.jsで班配列にGが含まれているか確認
cat /var/www/2590interact.net/interact/routes/index.js | grep "groups"
```

## 📝 デプロイチェックリスト

### デプロイ前
- [ ] ローカルで最終動作確認
- [ ] データベース（database.db）にデータが入っている
- [ ] fix014の機能が動作している（学生名ボタン）
- [ ] G班が表示される
- [ ] 本番環境バックアップ取得
- [ ] デプロイ手順の確認

### デプロイ中
- [ ] ファイル転送完了
- [ ] database.dbが含まれている確認
- [ ] 依存関係インストール完了
- [ ] データベースファイルの権限設定完了
- [ ] PM2起動完了

### デプロイ後
- [ ] サイト表示確認
- [ ] 学生名ボタン表示確認
- [ ] 学生ログイン動作確認
- [ ] 管理画面動作確認
- [ ] G班表示確認
- [ ] ログにエラーなし
- [ ] 旧環境の整理（数日後）

## 🎉 デプロイ完了後

```bash
# 不要な一時ファイル削除
rm /tmp/interact-site.tar.gz

# 旧環境は数日間保持（問題なければ削除）
# 確認後に実行:
# sudo rm -rf /var/www/2590interact.net/interact_old_*

# デプロイログ記録
echo "$(date): 本番環境デプロイ完了（fix014対応、G班追加、ローカルデータ移行）" | sudo tee -a /var/www/deploy.log
```

## 📌 重要な変更点（fix014対応）

### 1. 学生ログイン方式の変更
- **旧**: 名前とパスワードを入力
- **新**: 学生名ボタンをクリック→パスワードのみ入力

### 2. G班の追加
- A～F班（6班）→ A～G班（7班）に拡張

### 3. データベースファイル名
- **正しいファイル名**: `database.db`
- **間違った名前**: `database.sqlite`（使用しない）

---

**所要時間:** 約10-15分  
**ダウンタイム:** 約5-10分  
**リスク:** バックアップ取得済みのため低リスク  
**重要**: ローカルのdatabase.dbをそのまま本番環境に移行します
