# fix014.md - 学生ログインを名前ボタン＋パスワードのみの方式に変更 & G班追加

## 📋 修正概要
**作成日**: 2025-10-29  
**優先度**: 🔴 高（本番環境移行前の必須修正）  
**カテゴリ**: 仕様変更 + 機能追加

---

## 🚨 修正が必要な問題

### 問題1: 名前入力でのログインが難しい
**現状の問題**:
- 名前を正確に入力する必要があり、学生にとって難しい
- 漢字の入力間違い、スペースの有無などでログインできない

**新しい仕様（最もシンプルな方式）**:
- **メインページに学生の名前ボタンを並べる**
- **ボタンをクリックするとパスワード入力画面が表示される**
- **パスワードのみを入力してログイン**
- 学生は自分の名前ボタンを見つけてクリックするだけ

**この変更のメリット**:
- 名前を入力する必要がない（ボタンをクリックするだけ）
- 最もシンプルで分かりやすい
- 入力ミスが発生しない

### 問題2: 学生の班がG班まで対応していない
**現状の問題**:
- 現在の班はA班～F班までの6班のみ
- G班の学生を追加できない

---

## ✅ 修正内容

### 修正1: 学生名ボタン＋パスワードのみのログイン方式

#### 1-1. `views/index.ejs` の修正

**ファイル**: `views/index.ejs`

**修正箇所1**: 学生ログインセクションを学生名ボタン方式に変更

メインページ下部の学生ログインセクションを以下のように変更してください：

```ejs
<!-- 学生ログインセクション -->
<section id="student-login" class="section">
  <div class="container">
    <h2 style="text-align: center; margin-bottom: 10px;">
      <i class="bi bi-person-circle"></i> 学生ログイン
    </h2>
    <p style="text-align: center; color: #666; margin-bottom: 30px;">
      プロフィール編集を行う学生の方は、自分の名前をクリックしてください。
    </p>
    
    <!-- 学生名ボタン一覧 -->
    <div class="student-login-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 15px; max-width: 1000px; margin: 0 auto;">
      <% if (typeof students !== 'undefined' && students.length > 0) { %>
        <% students.forEach(student => { %>
          <a href="/student/<%= student.id %>/login" class="student-login-button" style="display: flex; flex-direction: column; align-items: center; padding: 20px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border: 2px solid #dee2e6; border-radius: 12px; text-decoration: none; color: #333; transition: all 0.3s; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
            <div style="width: 60px; height: 60px; background: #2590ff; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 10px; color: white; font-size: 24px; font-weight: bold;">
              <%= student.name.substring(0, 1) %>
            </div>
            <div style="font-weight: bold; font-size: 16px; margin-bottom: 5px;">
              <%= student.name %>
            </div>
            <div style="font-size: 13px; color: #666;">
              <%= student.school %>
            </div>
            <div style="font-size: 12px; color: #999; margin-top: 5px;">
              <%= student.group %>班
            </div>
          </a>
        <% }) %>
      <% } else { %>
        <p style="text-align: center; color: #999;">学生情報がありません</p>
      <% } %>
    </div>
    
    <style>
      .student-login-button:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(37, 144, 255, 0.3) !important;
        border-color: #2590ff !important;
      }
      
      @media (max-width: 768px) {
        .student-login-grid {
          grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)) !important;
          gap: 10px !important;
        }
        .student-login-button {
          padding: 15px !important;
        }
      }
    </style>
  </div>
</section>
```

#### 1-2. `routes/student.js` の修正

**ファイル**: `routes/student.js`

**修正箇所1**: 学生個別のログインページを追加

以下のルートを追加してください（POST /student/loginの前に追加）：

```javascript
// GET /student/:id/login - 学生個別のログインページ（パスワード入力のみ）
router.get('/:id/login', (req, res) => {
  const studentId = parseInt(req.params.id);
  
  db.get(
    'SELECT * FROM participants WHERE id = ? AND type = "student"',
    [studentId],
    (err, student) => {
      if (err || !student) {
        return res.redirect('/#student-login');
      }
      
      res.render('student/login', { 
        student,
        error: null
      });
    }
  );
});
```

**修正箇所2**: ログイン処理をパスワードのみに変更

既存のPOST /student/loginルートを以下のように修正してください：

```javascript
// POST /student/login - ログイン処理（パスワードのみ）
router.post('/login', (req, res) => {
  const { studentId, password } = req.body;
  
  if (!studentId || !password) {
    return db.get(
      'SELECT * FROM participants WHERE id = ? AND type = "student"',
      [studentId],
      (err, student) => {
        res.render('student/login', { 
          student: student || {},
          error: 'パスワードを入力してください' 
        });
      }
    );
  }
  
  db.get(
    'SELECT * FROM participants WHERE id = ? AND type = "student"',
    [studentId],
    async (err, student) => {
      if (err || !student) {
        return res.redirect('/#student-login');
      }
      
      try {
        const match = await bcrypt.compare(password, student.password);
        if (match) {
          req.session.studentId = student.id;
          // ログイン成功後、自分の編集ページへリダイレクト
          return res.redirect(`/student/${student.id}/edit`);
        } else {
          return res.render('student/login', { 
            student,
            error: 'パスワードが間違っています' 
          });
        }
      } catch (error) {
        return res.render('student/login', { 
          student,
          error: 'ログインに失敗しました' 
        });
      }
    }
  );
});
```

**修正箇所3**: `requireStudentAuth` ミドルウェアの確認（変更不要）

```javascript
// 既存のrequireStudentAuthミドルウェアはそのまま（変更不要）
function requireStudentAuth(req, res, next) {
  const studentId = parseInt(req.params.id);
  
  if (req.session.isAdmin) {
    return next();
  }
  
  if (req.session.studentId && req.session.studentId === studentId) {
    return next();
  }
  
  return res.redirect('/#student-login');
}
```

#### 1-3. `views/student/login.ejs` の修正

**ファイル**: `views/student/login.ejs`

**修正箇所**: パスワードのみのログインフォームに変更

```ejs
<!DOCTYPE html>
<html lang="ja">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>学生ログイン - <%= typeof student !== 'undefined' ? student.name : '' %></title>
  <link rel="stylesheet" href="/css/style.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
</head>
<body>
  <div class="container" style="max-width: 500px; margin: 50px auto; padding: 20px;">
    <!-- 学生情報表示 -->
    <% if (typeof student !== 'undefined' && student) { %>
      <div style="text-align: center; margin-bottom: 30px;">
        <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #2590ff 0%, #1a73cc 100%); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin-bottom: 15px; color: white; font-size: 32px; font-weight: bold; box-shadow: 0 4px 10px rgba(37, 144, 255, 0.3);">
          <%= student.name.substring(0, 1) %>
        </div>
        <h1 style="margin: 0; font-size: 24px; color: #333;">
          <%= student.name %>
        </h1>
        <p style="margin: 5px 0 0 0; color: #666; font-size: 14px;">
          <%= student.school %> / <%= student.group %>班
        </p>
      </div>
      
      <div style="background: #f8f9fa; padding: 30px; border-radius: 12px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
        <h2 style="text-align: center; margin-bottom: 20px; font-size: 18px; color: #333;">
          <i class="bi bi-lock"></i> パスワードを入力してください
        </h2>
        
        <% if (typeof error !== 'undefined' && error) { %>
          <div class="alert alert-danger" style="padding: 12px; margin-bottom: 20px; background: #f8d7da; border: 1px solid #f5c6cb; border-radius: 8px; color: #721c24; text-align: center;">
            <i class="bi bi-exclamation-circle"></i> <%= error %>
          </div>
        <% } %>
        
        <form action="/student/login" method="POST">
          <input type="hidden" name="studentId" value="<%= student.id %>">
          
          <div class="form-group" style="margin-bottom: 25px;">
            <label for="password" style="display: block; margin-bottom: 8px; font-weight: bold; color: #333;">
              <i class="bi bi-key"></i> パスワード
            </label>
            <input 
              type="password" 
              id="password" 
              name="password" 
              class="form-control" 
              required
              autofocus
              placeholder="パスワードを入力"
              style="width: 100%; padding: 14px; border: 2px solid #dee2e6; border-radius: 8px; font-size: 16px; transition: border-color 0.3s;"
              onfocus="this.style.borderColor='#2590ff'"
              onblur="this.style.borderColor='#dee2e6'"
            >
          </div>
          
          <button 
            type="submit" 
            class="btn btn-primary" 
            style="width: 100%; padding: 14px; background: linear-gradient(135deg, #2590ff 0%, #1a73cc 100%); color: white; border: none; border-radius: 8px; font-size: 16px; font-weight: bold; cursor: pointer; transition: transform 0.2s; box-shadow: 0 2px 5px rgba(37, 144, 255, 0.3);"
            onmouseover="this.style.transform='translateY(-2px)'"
            onmouseout="this.style.transform='translateY(0)'"
          >
            <i class="bi bi-box-arrow-in-right"></i> ログイン
          </button>
        </form>
        
        <div style="text-align: center; margin-top: 20px;">
          <a href="/#student-login" style="color: #6c757d; text-decoration: none; font-size: 14px;">
            <i class="bi bi-arrow-left"></i> 学生選択に戻る
          </a>
        </div>
      </div>
      
      <div style="text-align: center; margin-top: 20px; color: #999; font-size: 13px;">
        <p>
          <i class="bi bi-info-circle"></i> 
          パスワードがわからない場合は、引率の先生にお問い合わせください。
        </p>
      </div>
    <% } else { %>
      <div style="text-align: center; padding: 50px;">
        <p style="color: #999; font-size: 16px;">学生情報が見つかりません</p>
        <a href="/" class="btn btn-secondary" style="margin-top: 20px;">
          <i class="bi bi-arrow-left"></i> トップページに戻る
        </a>
      </div>
    <% } %>
  </div>
</body>
</html>
```

#### 1-4. `views/student-profile.ejs` の修正（確認のみ）

**ファイル**: `views/student-profile.ejs`

**確認事項**: 既にfix013で編集ボタンが削除されていることを確認

```ejs
<!-- アクションボタンエリア -->
<div class="action-buttons" style="text-align: center; margin-top: 30px;">
  <a href="/" class="btn btn-secondary">
    <i class="bi bi-arrow-left"></i> トップページに戻る
  </a>
</div>

<!-- 学生ログインへの誘導メッセージ -->
<div style="text-align: center; margin-top: 20px; padding: 15px; background: #f8f9fa; border-radius: 8px;">
  <p style="margin: 0; color: #666; font-size: 14px;">
    <i class="bi bi-info-circle"></i> 
    プロフィールを編集する場合は、
    <a href="/#student-login" style="color: #2590ff; font-weight: bold;">メインページ下部の学生ログイン</a>
    から自分の名前を選択してログインしてください。
  </p>
</div>
```

#### 1-5. `routes/index.js` の修正

**ファイル**: `routes/index.js`

**修正箇所**: メインページに学生データを渡す（学生ログインボタン用）

メインページのルーティング（GET /）で、studentsデータがテンプレートに渡されていることを確認してください：

```javascript
router.get('/', (req, res) => {
  // ... お知らせ、行程表、参加者データの取得 ...
  
  // 学生データをログイン用にも使用するため、そのまま渡す
  res.render('index', {
    news,
    schedules,
    groupedStudents,
    students,  // ← これが必要（学生ログインボタン表示用）
    companions,
    chaperones,
    information
  });
});
```

---

### 修正2: G班の追加

#### 2-1. `views/admin/participants.ejs` の修正

**ファイル**: `views/admin/participants.ejs`

**修正箇所**: 班の選択肢にG班を追加

```html
<!-- 参加者追加フォーム内の班選択 -->
<div class="form-group" id="groupField">
  <label for="group">班 <span style="color: red;">*</span></label>
  <select id="group" name="group" required>
    <option value="">選択してください</option>
    <option value="A">A班</option>
    <option value="B">B班</option>
    <option value="C">C班</option>
    <option value="D">D班</option>
    <option value="E">E班</option>
    <option value="F">F班</option>
    <option value="G">G班</option>  <!-- ← 追加 -->
  </select>
</div>

<!-- 編集モーダル内も同様 -->
```

#### 2-2. `routes/index.js` の修正

**修正箇所**: 班配列にGを追加

```javascript
// 学生を班別にグループ化（A～Gまで対応）
const groups = ['A', 'B', 'C', 'D', 'E', 'F', 'G'];  // ← Gを追加
```

---

## 🧪 動作確認テスト

### 学生名ボタンログインのテスト

#### テスト1: メインページに学生名ボタンが表示される
```
http://localhost:3000/#student-login
```
- **期待**: 全学生の名前ボタンが一覧表示される
- **期待**: 各ボタンに学生名、学校名、班が表示される

#### テスト2: 学生名ボタンをクリック
1. 任意の学生名ボタンをクリック
- **期待**: その学生専用のパスワード入力ページが表示される
- **期待**: 学生名、学校名、班が表示される

#### テスト3: パスワード入力でログイン
1. パスワードを入力して「ログイン」をクリック
- **期待**: ログイン成功後、編集ページ（`/student/1/edit`）にリダイレクト

#### テスト4: 間違ったパスワード
1. 間違ったパスワードを入力
- **期待**: 「パスワードが間違っています」エラーが表示される
- **期待**: 同じページに留まる

#### テスト5: 未ログインで編集ページにアクセス
```
http://localhost:3000/student/1/edit （シークレットモード）
```
- **期待**: メインページの学生ログインセクション（`/#student-login`）にリダイレクト

#### テスト6: 編集ページで編集可能
1. ログイン後、各項目を編集
2. 「保存」をクリック
- **期待**: 正常に保存される

#### テスト7: ログアウト機能
1. 編集ページの「ログアウト」をクリック
- **期待**: メインページの学生ログインセクションにリダイレクト

### G班追加のテスト

#### テスト8: 管理画面でG班を追加
```
http://localhost:3000/admin
```
- **期待**: G班の学生が追加できる

#### テスト9: メインページでG班が表示
- **期待**: G班セクションとG班の学生ログインボタンが表示される

---

## 📁 修正対象ファイル一覧

### 学生名ボタンログイン
- [ ] `views/index.ejs` - 学生ログインセクションをボタン方式に変更
- [ ] `routes/student.js` - 学生個別ログインページ追加、ログイン処理修正
- [ ] `views/student/login.ejs` - パスワードのみのフォームに変更
- [ ] `views/student-profile.ejs` - 誘導メッセージ確認
- [ ] `routes/index.js` - studentsデータをテンプレートに渡す確認

### G班追加
- [ ] `views/admin/participants.ejs` - 班選択肢にG班追加
- [ ] `routes/index.js` - 班配列にGを追加
- [ ] `views/index.ejs` - G班表示確認（通常は自動対応）

---

## 🔧 実装手順

### ステップ1: 学生名ボタンログイン（最優先）
1. `views/index.ejs` の学生ログインセクションを修正
2. `routes/student.js` に学生個別ログインページ（GET /student/:id/login）を追加
3. 同じファイルのPOST /student/loginを修正（パスワードのみ）
4. `views/student/login.ejs` をパスワードのみのフォームに変更
5. `routes/index.js` でstudentsデータがテンプレートに渡されているか確認
6. サーバーを再起動してテスト実施（テスト1～7）

### ステップ2: G班追加
1. `views/admin/participants.ejs` の班選択肢を修正
2. `routes/index.js` の班配列にGを追加
3. サーバーを再起動してテスト実施（テスト8～9）

---

## ⚠️ 注意事項

### 学生名ボタン方式のメリット
- **入力不要**: 学生は自分の名前ボタンをクリックするだけ
- **視覚的**: 全学生が一目で確認できる
- **エラーなし**: 名前の入力ミスが発生しない
- **最もシンプル**: パスワードだけ入力すればOK

### セキュリティ
- 学生IDはURLに含まれるが、パスワードなしでは編集できない
- 編集ページへの直接アクセスは引き続き認証必須

### データベース
- G班の追加はスキーマ変更不要
- 既存データへの影響なし

---

## 📋 完了チェックリスト

### 学生名ボタンログイン
- [ ] `index.ejs` 学生ログインセクション修正完了
- [ ] `routes/student.js` 個別ログインページ追加完了
- [ ] `routes/student.js` ログイン処理修正完了
- [ ] `student/login.ejs` パスワードフォーム修正完了
- [ ] `routes/index.js` studentsデータ確認完了
- [ ] テスト1～7の全てがパス

### G班追加
- [ ] `admin/participants.ejs` 修正完了
- [ ] `routes/index.js` 修正完了
- [ ] テスト8～9がパス

### 総合確認
- [ ] サーバー正常起動
- [ ] 全機能正常動作
- [ ] 全テストパス

---

## 🎯 期待される結果

### 学生名ボタンログイン後
- メインページに全学生の名前ボタンが表示される
- 学生は自分の名前ボタンをクリック
- パスワードのみを入力してログイン
- 最もシンプルで分かりやすい方式

### G班追加後
- G班の学生を追加・編集できる
- メインページでG班が表示される
- G班の学生もログインボタンが表示される

---

**修正完了後、このファイルを `history.md` に追記してください。**
