# fix013 修正指示書 - 使用ガイド（修正版）

## 📌 修正内容サマリー

### 🔄 仕様変更（最優先）
**問題**: 参加者詳細画面からの編集でエラー発生  
**解決策**: 参加者詳細画面を閲覧専用にし、メインページ下部のログインフォームからのみ編集可能に変更

**変更点**:
- ❌ 参加者詳細画面の編集ボタンを削除
- ✅ メインページ下部に学生ログインフォームを設置（既存）
- ✅ ログイン後は自動的に編集ページへリダイレクト
- ✅ 編集ページにログアウトボタンを追加

### ➕ 機能追加
**追加内容**: 学生の班をA～F班（6班）からA～G班（7班）に拡張

---

## 📄 作成ファイル一覧

### 1. 詳細な修正指示書（開発者向け）
**ファイル名**: `fix013-revised.md`  
**用途**: 詳細な実装内容、テストケース、注意事項を含む完全版  
**推奨対象**: プロジェクト全体を理解している開発者

### 2. Claude Code向けプロンプト（推奨）
**ファイル名**: `claude-code-prompt-fix013-revised.md`  
**用途**: Claude Codeにそのまま渡せる実装指示  
**推奨対象**: Claude Codeを使用する場合（最も簡単）

### 3. このファイル
**ファイル名**: `fix013-usage-guide.md`  
**用途**: どのファイルを使えばいいかのガイド

---

## 🚀 実装方法

### 方法1: Claude Codeを使用（推奨・最も簡単）

```bash
# Claude Codeを起動
claude code

# プロンプトファイルを渡す
# 以下のコマンドでファイルの内容をClaude Codeに渡してください
```

または、`claude-code-prompt-fix013-revised.md` の内容をコピーしてClaude Codeに貼り付けてください。

### 方法2: 手動で実装

`fix013-revised.md` を参照しながら、以下のファイルを順番に修正してください：

#### ステップ1: 仕様変更（最優先）
1. `routes/student.js` を修正（3箇所）
   - プロフィール表示ページの簡素化
   - ログイン処理の修正
   - requireStudentAuthの修正

2. `views/student-profile.ejs` を修正
   - 編集ボタンの完全削除

3. `views/student/edit.ejs` を修正
   - ログアウトボタンの追加

4. `views/index.ejs` を確認
   - 学生ログインフォームの存在確認

#### ステップ2: G班追加
1. `views/admin/participants.ejs` を修正
   - 班選択肢にG班を追加

2. `routes/index.js` を修正
   - 班配列に'G'を追加

3. `views/index.ejs` を確認
   - G班の表示確認

---

## 🧪 テスト項目

### 仕様変更のテスト（6項目）
- [ ] テスト1: 参加者詳細画面が閲覧専用
- [ ] テスト2: メインページから学生ログイン成功
- [ ] テスト3: 編集ページで編集可能
- [ ] テスト4: 未ログインで編集ページにアクセス不可
- [ ] テスト5: 他の学生の編集ページにアクセス不可
- [ ] テスト6: ログアウト機能が正常動作

### G班追加のテスト（2項目）
- [ ] テスト7: 管理画面でG班を追加可能
- [ ] テスト8: メインページでG班が表示される

---

## ⚠️ 重要な注意事項

1. **バックアップを取ってから作業してください**
   ```bash
   npm run backup-db
   ```

2. **仕様変更を先に完了させてください**
   - G班追加よりも先に学生ログイン周りを修正

3. **サーバーの再起動を忘れずに**
   ```bash
   npm run dev
   ```

4. **シークレットモードでテストしてください**
   - 通常ブラウザだとセッションが残っている可能性があります

---

## 📊 修正対象ファイル一覧

### 仕様変更（優先）
- [ ] `routes/student.js`
- [ ] `views/student-profile.ejs`
- [ ] `views/student/edit.ejs`
- [ ] `views/index.ejs`（確認のみ）

### G班追加
- [ ] `views/admin/participants.ejs`
- [ ] `routes/index.js`
- [ ] `views/index.ejs`（確認のみ）

**合計**: 最大7ファイル（確認のみを含む）

---

## 🎯 期待される結果

### 仕様変更後
✅ 参加者詳細画面は純粋な閲覧専用  
✅ 学生はメインページ下部からログイン  
✅ ログイン後は自動的に編集ページへ  
✅ エラーが発生しにくいシンプルな導線

### G班追加後
✅ G班の学生を追加・編集可能  
✅ メインページでG班が表示される  
✅ A～F班の既存機能に影響なし

---

## 💡 この修正の効果

1. **シンプルな導線**: ログインフォーム → 編集ページ という明確な流れ
2. **エラーの削減**: 複雑な権限チェックを削減
3. **セキュリティ維持**: 編集ページへの直接アクセスは引き続き保護
4. **ユーザビリティ向上**: 学生にとってわかりやすい操作

---

## 📞 サポート

実装中に問題が発生した場合：

1. まず `fix013-revised.md` の該当箇所を再確認
2. テストケースを順番に実施
3. エラーメッセージを確認

それでも解決しない場合は、以下を報告してください：
- エラーメッセージ
- 実施した手順
- 修正したファイル名

---

**本番環境移行前の最終修正です。丁寧に実装とテストを行ってください。**
