# Claude Code向け 編集機能不具合修正 指示書

## 🎯 作業概要
2590地区インターアクト研修旅行サイトの編集機能に不具合があるため、修正をお願いします。

## 📋 現在の状況

### プロジェクト情報
- **作業ディレクトリ:** `~/Developer/projects/interact-travel-site/`
- **開発URL:** http://localhost:3000
- **管理画面URL:** http://localhost:3000/admin (admin / dev2590)

### 動作確認済み機能
- ✅ サイト基本表示
- ✅ 管理画面ログイン
- ✅ データの表示（お知らせ、行程表、参加者）
- ✅ 削除機能（正常動作）

### 🚨 修正が必要な不具合
- ❌ **行程表の「編集」ボタンが機能しない**
- ❌ **参加者の「編集」ボタンが機能しない**
- ❌ **お知らせの「編集」ボタンも同様の可能性**

## 🔧 修正指示

### 1. 事前確認作業
```bash
# プロジェクトディレクトリに移動
cd ~/Developer/projects/interact-travel-site

# history.mdの内容を確認
cat history.md

# 現在のファイル構成確認
ls -la views/
ls -la public/js/
```

### 2. 問題の特定
以下を確認・修正してください：

#### A. JavaScriptエラーの確認
- `public/js/` 内のJavaScriptファイルでコンソールエラーがないか確認
- 編集ボタンのクリックイベントが正しく設定されているか確認

#### B. モーダル・フォーム表示の確認
- 編集用モーダルが正しく表示されるか確認
- 編集フォームのHTML構造が正しいか確認

#### C. API エンドポイントの確認
- PUT/PATCH リクエストが正しく処理されているか確認
- `routes/admin.js` の編集用エンドポイントが動作するか確認

### 3. 具体的な修正対象

#### 対象ファイル（推測）
```
views/admin.ejs          # 管理画面テンプレート
public/js/admin.js       # 管理画面JavaScript
routes/admin.js          # 管理画面API
```

#### 確認すべき機能
1. **お知らせ編集**
   - 編集ボタンクリック → モーダル表示 → データ更新

2. **行程表編集**
   - 編集ボタンクリック → フォーム表示 → データ更新

3. **参加者編集**
   - 編集ボタンクリック → 編集画面 → データ更新

### 4. 修正例（参考）

#### JavaScript修正例
```javascript
// 編集ボタンのイベントリスナー
document.addEventListener('DOMContentLoaded', function() {
    // 編集ボタンにイベント追加
    document.querySelectorAll('.edit-btn').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const id = this.dataset.id;
            const type = this.dataset.type;
            openEditModal(id, type);
        });
    });
});

// モーダル表示関数
function openEditModal(id, type) {
    // モーダル表示処理
    const modal = document.getElementById('editModal');
    if (modal) {
        modal.style.display = 'block';
        loadEditData(id, type);
    }
}
```

#### API修正例
```javascript
// PUT エンドポイントの確認
router.put('/api/news/:id', async (req, res) => {
    try {
        const { title, content } = req.body;
        // データ更新処理
        res.json({ success: true });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
});
```

## ✅ 修正完了後の確認項目

### 動作テスト手順
1. **開発サーバー起動**
   ```bash
   npm run dev
   ```

2. **管理画面アクセス**
   ```
   http://localhost:3000/admin
   ID: admin / PW: dev2590
   ```

3. **各編集機能のテスト**
   - [ ] お知らせ編集ボタン → モーダル表示 → 内容変更 → 保存
   - [ ] 行程表編集ボタン → フォーム表示 → 内容変更 → 保存
   - [ ] 参加者編集ボタン → 編集画面 → 内容変更 → 保存

4. **ブラウザコンソール確認**
   - F12でデベロッパーツール開く
   - Consoleタブでエラーがないことを確認

## 🚨 トラブルシューティング

### よくある修正パターン

#### パターン1: イベントリスナー未設定
```javascript
// 修正前（動かない）
$('.edit-btn').click(function() { ... });

// 修正後（動く）
$(document).on('click', '.edit-btn', function() { ... });
```

#### パターン2: モーダルHTML不備
```html
<!-- 必要な要素が不足している場合 -->
<div id="editModal" class="modal">
    <div class="modal-content">
        <span class="close">&times;</span>
        <form id="editForm">
            <!-- フォーム内容 -->
        </form>
    </div>
</div>
```

#### パターン3: API呼び出し失敗
```javascript
// エラーハンドリング追加
fetch(`/admin/api/news/${id}`, {
    method: 'PUT',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(data)
})
.then(response => response.json())
.then(data => {
    if (data.success) {
        location.reload(); // 画面更新
    }
})
.catch(error => console.error('Error:', error));
```

## 📝 修正完了報告

修正完了時に以下を報告してください：
1. **修正したファイルリスト**
2. **修正内容の詳細**
3. **動作確認結果**
4. **残っている問題（あれば）**

## 🎯 追加要望（修正後に対応）

編集機能修正後、以下の改善も検討：
- 編集成功時のメッセージ表示
- バリデーション機能強化
- UX向上（ローディング表示等）

---

**重要:** まずは基本的な編集機能を動作させることを最優先としてください。UI/UXの改善は後回しで構いません。