# Claude Code 実装プロンプト - fix014（簡潔版）

## 📌 実装内容

2つの修正を実施してください：
1. **学生ログインを名前ボタン＋パスワードのみの方式に変更**
2. **G班を追加（A～Gの7班対応）**

---

## 🔄 修正1: 学生名ボタン＋パスワードのみのログイン

### 新しい仕様
- メインページに学生の名前ボタンを一覧表示
- ボタンクリック → その学生専用のパスワード入力ページへ
- パスワードのみ入力でログイン → 編集ページへ

---

## 📝 実装内容

### 1. `views/index.ejs` - 学生ログインセクションをボタン方式に変更

メインページ下部の`#student-login`セクションを以下に置き換え：

```ejs
<!-- 学生ログインセクション -->
<section id="student-login" class="section">
  <div class="container">
    <h2 style="text-align: center; margin-bottom: 10px;">
      <i class="bi bi-person-circle"></i> 学生ログイン
    </h2>
    <p style="text-align: center; color: #666; margin-bottom: 30px;">
      プロフィール編集を行う学生の方は、自分の名前をクリックしてください。
    </p>
    
    <!-- 学生名ボタン一覧 -->
    <div class="student-login-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 15px; max-width: 1000px; margin: 0 auto;">
      <% if (typeof students !== 'undefined' && students.length > 0) { %>
        <% students.forEach(student => { %>
          <a href="/student/<%= student.id %>/login" class="student-login-button" style="display: flex; flex-direction: column; align-items: center; padding: 20px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border: 2px solid #dee2e6; border-radius: 12px; text-decoration: none; color: #333; transition: all 0.3s; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
            <div style="width: 60px; height: 60px; background: #2590ff; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 10px; color: white; font-size: 24px; font-weight: bold;">
              <%= student.name.substring(0, 1) %>
            </div>
            <div style="font-weight: bold; font-size: 16px; margin-bottom: 5px;">
              <%= student.name %>
            </div>
            <div style="font-size: 13px; color: #666;">
              <%= student.school %>
            </div>
            <div style="font-size: 12px; color: #999; margin-top: 5px;">
              <%= student.group %>班
            </div>
          </a>
        <% }) %>
      <% } %>
    </div>
    
    <style>
      .student-login-button:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(37, 144, 255, 0.3) !important;
        border-color: #2590ff !important;
      }
      @media (max-width: 768px) {
        .student-login-grid {
          grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)) !important;
        }
      }
    </style>
  </div>
</section>
```

---

### 2. `routes/student.js` - 2箇所修正

#### 追加: 学生個別ログインページ（POST /student/loginの前に追加）

```javascript
// GET /student/:id/login - 学生個別のログインページ
router.get('/:id/login', (req, res) => {
  const studentId = parseInt(req.params.id);
  
  db.get(
    'SELECT * FROM participants WHERE id = ? AND type = "student"',
    [studentId],
    (err, student) => {
      if (err || !student) {
        return res.redirect('/#student-login');
      }
      res.render('student/login', { student, error: null });
    }
  );
});
```

#### 修正: POST /student/login - パスワードのみのログイン処理

既存のPOST /student/loginを以下に置き換え：

```javascript
// POST /student/login - ログイン処理（パスワードのみ）
router.post('/login', (req, res) => {
  const { studentId, password } = req.body;
  
  if (!password) {
    return db.get(
      'SELECT * FROM participants WHERE id = ? AND type = "student"',
      [studentId],
      (err, student) => {
        res.render('student/login', { 
          student: student || {},
          error: 'パスワードを入力してください' 
        });
      }
    );
  }
  
  db.get(
    'SELECT * FROM participants WHERE id = ? AND type = "student"',
    [studentId],
    async (err, student) => {
      if (err || !student) {
        return res.redirect('/#student-login');
      }
      
      try {
        const match = await bcrypt.compare(password, student.password);
        if (match) {
          req.session.studentId = student.id;
          return res.redirect(`/student/${student.id}/edit`);
        } else {
          return res.render('student/login', { 
            student,
            error: 'パスワードが間違っています' 
          });
        }
      } catch (error) {
        return res.render('student/login', { 
          student,
          error: 'ログインに失敗しました' 
        });
      }
    }
  );
});
```

---

### 3. `views/student/login.ejs` - パスワードのみのフォームに変更

ファイル全体を以下に置き換え：

```ejs
<!DOCTYPE html>
<html lang="ja">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>学生ログイン - <%= typeof student !== 'undefined' ? student.name : '' %></title>
  <link rel="stylesheet" href="/css/style.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
</head>
<body>
  <div class="container" style="max-width: 500px; margin: 50px auto; padding: 20px;">
    <% if (typeof student !== 'undefined' && student) { %>
      <div style="text-align: center; margin-bottom: 30px;">
        <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #2590ff 0%, #1a73cc 100%); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin-bottom: 15px; color: white; font-size: 32px; font-weight: bold;">
          <%= student.name.substring(0, 1) %>
        </div>
        <h1 style="margin: 0; font-size: 24px;"><%= student.name %></h1>
        <p style="margin: 5px 0 0 0; color: #666; font-size: 14px;">
          <%= student.school %> / <%= student.group %>班
        </p>
      </div>
      
      <div style="background: #f8f9fa; padding: 30px; border-radius: 12px;">
        <h2 style="text-align: center; margin-bottom: 20px; font-size: 18px;">
          <i class="bi bi-lock"></i> パスワードを入力してください
        </h2>
        
        <% if (typeof error !== 'undefined' && error) { %>
          <div style="padding: 12px; margin-bottom: 20px; background: #f8d7da; border-radius: 8px; color: #721c24; text-align: center;">
            <%= error %>
          </div>
        <% } %>
        
        <form action="/student/login" method="POST">
          <input type="hidden" name="studentId" value="<%= student.id %>">
          <div style="margin-bottom: 25px;">
            <label for="password" style="display: block; margin-bottom: 8px; font-weight: bold;">パスワード</label>
            <input type="password" id="password" name="password" required autofocus
                   style="width: 100%; padding: 14px; border: 2px solid #dee2e6; border-radius: 8px; font-size: 16px;">
          </div>
          <button type="submit" style="width: 100%; padding: 14px; background: linear-gradient(135deg, #2590ff 0%, #1a73cc 100%); color: white; border: none; border-radius: 8px; font-size: 16px; font-weight: bold; cursor: pointer;">
            <i class="bi bi-box-arrow-in-right"></i> ログイン
          </button>
        </form>
        
        <div style="text-align: center; margin-top: 20px;">
          <a href="/#student-login" style="color: #6c757d; text-decoration: none;">
            <i class="bi bi-arrow-left"></i> 学生選択に戻る
          </a>
        </div>
      </div>
    <% } %>
  </div>
</body>
</html>
```

---

### 4. `routes/index.js` - studentsデータ確認

メインページのルーティング（GET /）で、`students`がテンプレートに渡されているか確認：

```javascript
res.render('index', {
  news,
  schedules,
  groupedStudents,
  students,  // ← これが必要
  companions,
  chaperones,
  information
});
```

---

## ✅ 修正2: G班追加

### 5. `views/admin/participants.ejs` - 班選択肢にG班追加

参加者追加フォームと編集モーダルの両方で：

```html
<select id="group" name="group" required>
  <option value="">選択してください</option>
  <option value="A">A班</option>
  <option value="B">B班</option>
  <option value="C">C班</option>
  <option value="D">D班</option>
  <option value="E">E班</option>
  <option value="F">F班</option>
  <option value="G">G班</option>  <!-- ← 追加 -->
</select>
```

### 6. `routes/index.js` - 班配列にG追加

```javascript
const groups = ['A', 'B', 'C', 'D', 'E', 'F', 'G'];  // ← Gを追加
```

---

## 🧪 テスト

### 学生名ボタンログイン
1. メインページ下部に学生名ボタンが一覧表示されるか
2. ボタンクリック → パスワード入力ページが表示されるか
3. パスワード入力 → 編集ページにリダイレクトされるか
4. 間違ったパスワード → エラー表示されるか

### G班
5. 管理画面でG班の学生を追加できるか
6. メインページでG班が表示されるか

---

## 📁 修正ファイル

- [ ] `views/index.ejs`
- [ ] `routes/student.js`（2箇所）
- [ ] `views/student/login.ejs`
- [ ] `routes/index.js`（studentsデータ確認 + G班追加）
- [ ] `views/admin/participants.ejs`

---

## ⚠️ 注意

1. バックアップ: `npm run backup-db`
2. サーバー再起動: `npm run dev`
3. シークレットモードでテスト

---

**この方式が最もシンプルです。学生は自分の名前ボタンをクリックしてパスワードを入力するだけ！**
